<?php
/**
 * This class used to backup all tables for this plugins.
 *
 * @author Flipper Code <hello@flippercode.com>
 * @version 3.0.0
 * @package Maps
 */


if ( isset( $_POST['operation'] ) and 'clean_database' == $_POST['operation'] ) {
	$clean_database = $response;
} else {
	$clean_database = array();
}

if ( isset( $_POST['operation'] ) and 'upload_sampledata' == $_POST['operation'] ) {
	$upload_sampledata = $response;
} else {
	$upload_sampledata = array();
}

	$import_form = new WPGMP_Template();
	$import_form->form_id = 'install_sample_data_form';

	$import_form->set_header( esc_html__( 'Install Sample Data', 'wpgmp-google-map' ), $upload_sampledata );

	$import_form->add_element(
		'group', 'install_database', array(
			'value'  => esc_html__( 'Install Sample Data', 'wpgmp-google-map' ),
			'before' => '<div class="fc-12">',
			'after'  => '</div>',
		)
	);

	$import_form->add_element(
		'hidden', 'operation', array(
			'value' => 'upload_sampledata',
		)
	);

	$import_form->add_element(
		'message', 'sampledata_message', array(
			'value' => esc_html__( 'Click below to install sample data. This is very useful to get started. 2 categories, 5 locations and 1 map will be created for demonstration purpose.', 'wpgmp-google-map' ),
			'class' => 'fc-msg fc-msg-info',
			'before' => '<div class="fc-12">',
			'after'  => '</div>',
		)
	);

	$import_form->add_element(
		'text', 'wpgmp_sampledata_consent', array(
			'lable'  => esc_html__( 'Verify Action', 'wpgmp-google-map' ),
			'class'  => 'form-control',
			'desc'   => esc_html__( 'Enter', 'wpgmp-google-map' ).' "YES" '.esc_html__( '& submit the button below to install sample map data.', 'wpgmp-google-map' ),
			'before' => '<div class="fc-4">',
			'after'  => '</div>',
		)
	);


	$import_form->add_element(
		'submit', 'wpgmp_sampledata_submit', array(
			'value' => esc_html__( 'Create Sample Data', 'wpgmp-google-map' ),
		)
	);

	$import_form->render();

	$form = new WPGMP_Template(array( 'no_header' => true ));
	$form->form_id = 'clean_wpgmp_database';
	$form->set_header( esc_html__( 'Clean Plugin Database', 'wpgmp-google-map' ), $clean_database );

	$form->add_element(
		'group', 'clean_database', array(
			'value'  => esc_html__( 'Clean Plugin Database', 'wpgmp-google-map' ),
			'before' => '<div class="fc-12">',
			'after'  => '</div>',
		)
	);

	$form->add_element(
		'hidden', 'operation', array(
			'value' => 'clean_database',
		)
	);

	$form->add_element(
		'message', 'backup_message', array(
			'value' => esc_html__( 'Enter "DELETE" in the below textbox and submit the form to remove all locations, maps, and categories i.e compelete database generated by our plugin. This method is not recommended on a live site as everything related to our plugin will be removed except plugin settings.', 'wpgmp-google-map' ),
			'class' => 'fc-msg fc-msg-info',
			'before' => '<div class="fc-12">',
			'after'  => '</div>',
		)
	);

	$form->add_element(
		'text', 'wpgmp_clean_consent', array(
			'lable'  => esc_html__( 'Verify Action', 'wpgmp-google-map' ),
			'id'     => 'wpgmp_consent',
			'class'  => 'form-control',
			'desc'   => esc_html__( 'Enter ', 'wpgmp-google-map' ).' "DELETE" '.esc_html__( ' to give consent that you actually want to remove all maps data generated by our plugin.', 'wpgmp-google-map' ),
			'before' => '<div class="fc-4">',
			'after'  => '</div>',
		)
	);

	$form->add_element(
		'submit', 'wpgmp_cleandatabase_tools', array(
			'value' => esc_html__( 'Submit', 'wpgmp-google-map' ),
		)
	);

	$form->render();

	
